<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Core\Model\Lang\Langs;
use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\SmartObject;
use Pages\FrontModule\Model\TemplatePages;

class TemplatePageListener implements EventSubscriberInterface
{
	use SmartObject;

	private Cache $cache;
	protected Langs $langs;

	public function __construct(IStorage $cacheStorage, Langs $langs)
	{
		$this->cache = new Cache($cacheStorage, TemplatePages::CACHE_NAMESPACE);
		$this->langs = $langs;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostPersist
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 */
	public function postHandler(TemplatePage $templatePage, LifecycleEventArgs $event): void
	{
		if ($templatePage->getId()) {
			foreach ($this->langs->getLangs(false) as $lang) {
				$this->cache->remove('templatePage/' . $templatePage->getId() . '/' . $lang->getTag());
			}
		}

		$this->cache->clean([
			Cache::TAGS => [TemplatePages::CACHE_NAMESPACE],
		]);
	}

}
