<?php declare(strict_types = 1);

namespace Pages\Model;

class Paths
{
	public function getTemplatePagesDir(string $site = 'default'): string { return TEMPLATES_DIR . '/Front/' . $site . '/Pages/TemplatePages'; }

	public function getTemplatePagesFile(string $name, string $site = 'default'): string
	{
		$tmp = explode('|', $name);

		if (count($tmp) == 2) {
			$name = $tmp[1];
			$site = $tmp[0];
		}

		return $this->getTemplatePagesDir($site) . '/' . $name;
	}

	public function getTemplateBlocksDir(): string { return TEMPLATES_DIR . '/Front/default/Pages/TemplateBlocks'; }

	public function getTemplateBlocksFile(string $name): string { return $this->getTemplateBlocksDir() . '/' . $name; }
}
