<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\Templating\TemplateFactory;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Pages\Model\Paths;
use Pages\FrontModule\Model\TemplateBlocks;

class Block extends TemplateTextType implements ITemplateTextType
{
	protected $type = 'block';

	protected TemplateBlocks  $templateBlocksService;
	protected TemplateFactory $templateFactory;
	protected Paths           $pathsService;

	public function __construct(
		TemplateBlocks  $templateBlocksService,
		TemplateFactory $templateFactory,
		Paths           $paths
	)
	{
		$this->templateBlocksService = $templateBlocksService;
		$this->templateFactory       = $templateFactory;
		$this->pathsService          = $paths;
	}

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$blocks    = ['' => ''];
		$allBlocks = $this->templateBlocksService->getEr()->findBy([], ['title' => 'ASC']);
		foreach ($allBlocks as $b) {
			$blocks[$b->getId()] = $b->title;
		}

		$formContainer->addSelect($this->getName(), $this->getTitle(), $blocks);
	}

	public function render(array $params)
	{
		if ($params['return'] === 'id') {
			return $this->getDefault();
		}

		$block = $this->templateBlocksService->get($this->getDefault());

		if (!$block) {
			return '';
		}

		// TODO přesunout do služby
		$template                  = $block->template;
		$latte                     = $this->templateFactory->createTemplate(null, null, false);
		$latte->templateTextValues = $block->getTexts();
		$latte->setFile($this->pathsService->getTemplateBlocksFile($template));

		return $latte->renderToString();
	}
}
