<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\Templating\TemplateFactory;
use Core\Model\Templating\Template;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Pages\Model\Paths;
use Pages\FrontModule\Model\TemplateBlocks;

class Blocks extends TemplateTextType implements ITemplateTextType
{
	protected $type = 'blocks';

	protected TemplateBlocks  $templateBlocksService;
	protected TemplateFactory $templateFactory;
	protected Paths           $pathsService;

	public function __construct(
		TemplateBlocks  $templateBlocksService,
		TemplateFactory $templateFactory,
		Paths           $paths
	)
	{
		$this->templateBlocksService = $templateBlocksService;
		$this->templateFactory       = $templateFactory;
		$this->pathsService          = $paths;
	}

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$items = [];
		foreach ($this->templateBlocksService->getEr()->createQueryBuilder('b')->select('b.id, b.title')
			         ->orderBy('b.title')->getQuery()->getArrayResult() as $b) {
			$items[$b['id']] = $b['title'];
		}

		$formContainer->addSortableCheckboxList($this->getName(), $this->getTitle(), $items);
	}

	public function render(array $params)
	{
		if ($params['return'] === 'id') {
			return $this->getDefault();
		}

		$content = '';
		$inArray = [];

		foreach ($this->getDefault() as $id) {
			$block = $this->templateBlocksService->get($id);

			if (!$block) {
				continue;
			}

			// TODO přesunout do služby
			$template = $block->template;

			/** @var Template $latte */
			$latte                     = $this->templateFactory->createTemplate();
			$latte->templateTextValues = $block->getTexts();
			$latte->setFile($this->pathsService->getTemplateBlocksFile($template));
			if (isset($params['toVar'])) {
				$inArray[] = $latte;
			} else {
				$content .= $latte->renderToString();
			}
		}

		return isset($params['toVar']) ? $inArray : $content;
	}
}
