<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;

class Date extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'date';

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$c = $formContainer->addDatePicker($this->getName(), $this->getTitle());
		if (isset($params['multiLang'])) {
			$c->setIsMultilanguage($params['multiLang']);
		}
	}

	public function render(array $params)
	{
		return $this->getDefault();
	}
}
