<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;

class DateTime extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'dateTime';

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$c = $formContainer->addDateTimePicker($this->getName(), $this->getTitle());
		if (isset($params['multiLang'])) {
			$c->setIsMultilanguage($params['multiLang']);
		}
	}

	public function render(array $params)
	{
		return $this->getDefault();
	}

	public static function getDateTime(?string $value): ?\DateTimeInterface
	{
		try {
			return $value ? \Nette\Utils\DateTime::createFromFormat('j. n. Y - H:i', $value) : null;
		} catch (\Exception $e) {

		}

		return null;
	}
}
