<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\Templating\Filters\EditorData;

class Editor extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'editor';

	protected EditorData $editorData;

	public function __construct(
		EditorData $editorData
	)
	{
		$this->editorData = $editorData;
	}

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$editor = $formContainer->addEditor($this->getName(), $this->getTitle())
			->setDisableAutoP($params['disableAutoP'] === 'true');
		if (isset($params['buttons'])) {
			$editor->setToolbarButtons($params['buttons']);
		} else if (isset($params['toolbar'])) {
			$editor->setToolbar($params['toolbar']);
		}

		if (isset($params['styles'])) {
			$editor->setStyles($params['styles']);
		}

		if (isset($params['height'])) {
			$editor->setHeight($params['height']);
		}

		if (isset($params['multiLang'])) {
			$editor->setIsMultilanguage($params['multiLang']);
		}
	}

	public function render(array $params)
	{
		$result = $this->getDefault();

		if (is_string($result)) {
			$result = $this->editorData->__invoke($result);
		} else if (is_array($result)) {
			foreach ($result as $k => $v) {
				if (is_string($v)) {
					$result[$k] = $this->editorData->__invoke($v);
				}
			}
		}

		return $result;
	}
}
