<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\Templating\TemplateFactory;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Pages\AdminModule\Model\TemplatePages;
use Pages\Model\Paths;

class Page extends TemplateTextType implements ITemplateTextType
{
	protected $type = 'templatePage';

	protected TemplatePages   $templatePages;
	protected TemplateFactory $templateFactory;
	protected Paths           $pathsService;

	public function __construct(
		TemplatePages   $templatePages,
		TemplateFactory $templateFactory,
		Paths           $paths
	)
	{
		$this->templatePages   = $templatePages;
		$this->templateFactory = $templateFactory;
		$this->pathsService    = $paths;
	}

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$blocks    = ['' => ''];
		$allBlocks = $this->templatePages->getEr()->findBy([], ['title' => 'ASC']);
		foreach ($allBlocks as $b) {
			$blocks[$b->getId()] = $b->title;
		}

		$formContainer->addSelect($this->getName(), $this->getTitle(), $blocks);
	}

	public function render(array $params)
	{
		$page = $this->templatePages->get($this->getDefault());

		if (!$page) {
			return '';
		}

		// TODO přesunout do služby
		$template                  = $page->template;
		$latte                     = $this->templateFactory->createTemplate(null, null, false);
		$latte->templateTextValues = $page->texts;
		$latte->setFile($this->pathsService->getTemplatePagesFile($template));

		return $latte->renderToString();
	}
}
