<?php declare(strict_types = 1);

namespace Pages\Model\Templating\Filters;

use Core\Model\Templating\TemplateFactory;
use Core\Model\UI\AbstractPresenter;
use Nette\Utils\Html;
use Pages\FrontModule\Model\TemplateBlocks as FrontTemplateBlocks;
use Pages\Model\Paths;
use Throwable;

class TemplateBlock
{
	protected FrontTemplateBlocks $frontTemplateBlocks;
	protected TemplateFactory     $templateFactory;
	protected Paths               $pathsService;

	public function __construct(FrontTemplateBlocks $frontTemplateBlocks, TemplateFactory $templateFactory, Paths $paths)
	{
		$this->frontTemplateBlocks = $frontTemplateBlocks;
		$this->templateFactory     = $templateFactory;
		$this->pathsService        = $paths;
	}

	/**
	 * @param string|int $id
	 *
	 * @return string|Html
	 * @throws Throwable
	 */
	public function __invoke($id)
	{
		$args  = func_get_args();
		$block = $this->frontTemplateBlocks->get($id);

		if (!$block) {
			return '';
		}

		// TODO přesunout do služby
		$template = $block->template;
		$latte    = $this->templateFactory->createTemplate();

		foreach ($args as $arg) {
			if ($arg instanceof AbstractPresenter) {
				$latte->presenter = $arg;
			} else if (is_array($arg)) {
				foreach ($arg as $k => $v) {
					$latte->$k = $v;
				}
			}
		}

		$latte->templateTextValues = $block->getTexts();
		$latte->setFile($this->pathsService->getTemplateBlocksFile($template));

		return (new Html())->setHtml($latte->renderToString());
	}
}
