<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200116205038 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE pages__template_page_group (id INT AUTO_INCREMENT NOT NULL, title VARCHAR(255) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE pages__template_page ADD site VARCHAR(255) DEFAULT NULL, ADD group_id INT DEFAULT NULL');
		$this->addSql('ALTER TABLE pages__template_page ADD CONSTRAINT FK_6E472687694309E4 FOREIGN KEY (site) REFERENCES core__site (ident) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE pages__template_page ADD CONSTRAINT FK_6E472687FE54D947 FOREIGN KEY (group_id) REFERENCES pages__template_page_group (id) ON DELETE SET NULL');
		$this->addSql('CREATE INDEX IDX_6E472687694309E4 ON pages__template_page (site)');
		$this->addSql('CREATE INDEX IDX_6E472687FE54D947 ON pages__template_page (group_id)');
	}

	public function postUp(Schema $schema): void
	{
		$sites = $this->connection->fetchAll("SELECT ident FROM core__site LIMIT 1");
		if ($sites[0]) {
			$this->connection->prepare("UPDATE pages__template_page SET site = ?")->execute([$sites[0]['ident']]);
		}
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE pages__template_page DROP FOREIGN KEY FK_6E472687FE54D947');
		$this->addSql('ALTER TABLE pages__template_page DROP FOREIGN KEY FK_6E472687694309E4');
		$this->addSql('DROP INDEX IDX_6E472687694309E4 ON pages__template_page');
		$this->addSql('DROP INDEX IDX_6E472687FE54D947 ON pages__template_page');
		$this->addSql('DROP TABLE pages__template_page_group');
		$this->addSql('ALTER TABLE pages__template_page DROP site, DROP group_id');
	}
}
