<?php declare(strict_types = 1);

namespace Pages\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Pages\Model\Entities\TemplateBlock;

/**
 * @method TemplateBlock|null getReference($id)
 * @method TemplateBlock[] getAll()
 * @method TemplateBlock|null get($id)
 */
class TemplateBlocks extends BaseEntityService
{
	protected $entityClass = TemplateBlock::class;

	protected ?array $cOpts = null;

	/**
	 * @return string[]
	 */
	public function getOptionsForSelect(): array
	{
		if ($this->cOpts === null) {
			$this->cOpts = [];

			foreach ($this->getEr()->createQueryBuilder('tb')->select('tb.id, tb.title')
				         ->orderBy('tb.title')
				         ->getQuery()->getArrayResult() as $row) {
				$this->cOpts[$row['id']] = $row['title'];
			}
		}

		return $this->cOpts;
	}
}
