<?php declare(strict_types = 1);

namespace Pages\AdminModule\Presenters;

use Core\AdminModule\Model\Sites;
use Core\Model\UI\Form\BaseForm;
use Exception;
use Nette\Application\ForbiddenRequestException;
use Nette\Application\UI\Multiplier;
use Pages\AdminModule\Components\ITemplatePageFormFactory;
use Pages\AdminModule\Components\ITemplatePageGroupsGridFactory;
use Pages\AdminModule\Components\ITemplatePagesGridFactory;
use Pages\AdminModule\Components\TemplatePageForm;
use Pages\AdminModule\Components\TemplatePageGroupsGrid;
use Pages\AdminModule\Components\TemplatePagesGrid;
use Pages\Model\Entities\TemplatePage;

class TemplatePagesPresenter extends BasePresenter
{
	/** @var Sites @inject */
	public $sitesService;

	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('pages.title.templatePages'));
		$this->setHeader('pages.title.templatePages', 'fa fa-file-image');
	}

	/**
	 * @param mixed $element
	 *
	 * @throws Exception
	 */
	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'accessTemplatePages')) {
			throw new ForbiddenRequestException();
		}
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		$this->template->sites = $this->sitesService->getAll();
		$this['navigation']->setData(['header' => [
			[
				'title' => 'pages.menu.newTemplatePage',
				'link'  => 'TemplatePages:add',
				'ico'   => 'plus',
			], [
				'title' => 'pages.menu.newGroup',
				'link'  => 'templatePageGroupsGrid:add!',
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		]]);
	}

	public function actionAdd(): void
	{
		$this->setHeader('pages.title.newTemplatePage', 'fa fa-file-image');
	}

	public function actionEdit(int $id): void
	{
		$page = $this->em->getRepository(TemplatePage::class)->find($id);

		if (!$page) {
			$this->error();
		}

		$this->setHeader('pages.title.editTemplatePage', 'fa fa-file-image');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentTemplatePagesGrid(ITemplatePagesGridFactory $factory): Multiplier
	{
		return new Multiplier(fn(string $sideIdent): TemplatePagesGrid => $factory->create($sideIdent));
	}

	protected function createComponentTemplatePageForm(ITemplatePageFormFactory $factory): TemplatePageForm
	{
		$control = $factory->create();

		if ($this->getParameter('id')) {
			$control->setPage((int) $this->getParameter('id'));
		}

		$control['form']->onSuccessSave[] = function(BaseForm $form): never {
			$this->redirect('edit', $form->getCustomData('templatePageId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(): never {
			$this->redirect('default');
		};
		$control['form']->onCancel[] = function(): never {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentTemplatePageGroupsGrid(ITemplatePageGroupsGridFactory $factory): TemplatePageGroupsGrid
	{
		return $factory->create();
	}

}
