<?php declare(strict_types = 1);

namespace Pages\FrontModule\Model\Dao;

use Nette\SmartObject;

class DaoTemplatePage
{
	use SmartObject;

	public function __construct(
		protected int    $id,
		protected string $title,
		protected array  $texts,
		protected string $template,
	)
	{
	}

	public function getId(): int { return $this->id; }

	public function getTitle(): string { return $this->title; }

	public function getTexts(): array { return $this->texts; }

	/**
	 * @return mixed|null
	 */
	public function getText(string $key) { return $this->texts[$key] ?? null; }

	public function getTemplate(): string { return $this->template; }
}
