<?php declare(strict_types = 1);

namespace Pages\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Nette\Caching\Cache;
use Pages\FrontModule\Model\Dao\DaoTemplateBlock;
use Pages\Model\Entities\TemplateBlock;
use Throwable;

class TemplateBlocks extends BaseFrontEntityService
{
	final public const CACHE_NAMESPACE = 'templateBlocks';

	protected $entityClass = TemplateBlock::class;

	protected array $cacheDep = [
		Cache::Tags    => [self::CACHE_NAMESPACE],
		Cache::Expire  => '1 week',
		Cache::Sliding => true,
	];

	public function getCache(): Cache
	{
		if ($this->cache === null) {
			$this->cache = new Cache($this->cacheStorage, self::CACHE_NAMESPACE);
		}

		return $this->cache;
	}

	/**
	 * @throws Throwable
	 */
	public function get(string|int $id): ?DaoTemplateBlock
	{
		$lang = $this->translator->getLocale();
		$key  = self::CACHE_NAMESPACE . '/' . $id . '/' . $lang;

		return $this->getCache()->load($key, function(&$dep) use ($id, $lang) {
			$dep = $this->cacheDep;

			$templateBlock = $this->getEr()->createQueryBuilder('tb')
				->select('tb.id, tb.title, tbt.texts, tb.template')
				->join('tb.texts', 'tbt', 'WITH', 'tbt.lang = :lang')
				->where('tb.id = :id')
				->setParameters([
					'id'   => $id,
					'lang' => $lang,
				])
				->getQuery()
				->setMaxResults(1)
				->getOneOrNullResult();

			return $templateBlock ? $this->fillDao($templateBlock) : null;
		});
	}

	protected function fillDao(array $data): DaoTemplateBlock
	{
		return new DaoTemplateBlock((int) $data['id'], $data['title'], $data['texts'], $data['template']);
	}
}
