<?php declare(strict_types = 1);

namespace Pages\FrontModule\Presenters;

use Pages\FrontModule\Model\Dao\DaoTemplatePage;
use Pages\FrontModule\Model\TemplatePages;
use Pages\Model\Helpers\TemplatePagesHelper;
use Pages\Model\Paths;

class DefaultPresenter extends BasePresenter
{
	public ?DaoTemplatePage $templatePage = null;

	public function __construct(
		protected TemplatePages       $templatePagesService,
		protected Paths               $pathsService,
		protected TemplatePagesHelper $pagesHelper,
	)
	{
		parent::__construct();
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionTemplatePage(?int $id = null): void
	{
		$id   = $id ?: (int) $this->getActiveNavigation()->componentParams['templatePage'];
		$page = $this->templatePagesService->get($id);

		if (!$page) {
			$this->error('pages.page.notFound');
		}

		$this->templatePage        = $page;
		$this->template->pageClass .= ' template-page tp-' . $page->getId();

		$texts = $page->getTexts();
		$texts = $this->pagesHelper->checkTexts($texts);

		if ($this->getParameter('pageOutput') === 'json') {
			$this->sendJson([
				'requestKey' => $this->getParameter('requestKey'),
				'texts'      => $texts,
			]);
		}

		$this['meta']->setMeta(
			'canonical',
			$this->getHttpRequest()
				->getUrl()
				->getBaseUrl() . ltrim($this->getActiveNavigation()->link, '/'),
		);

		$this->template->templateTextValues = $texts;
		$this->template->setFile($this->pathsService->getTemplatePagesFile($page->getTemplate()));
	}
}
