<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\Entities\TranslateListener;
use Core\Model\Entities\TTranslateListener;
use Core\Model\TemplateReader\Entity\ITemplate;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'pages__template_block')]
#[ORM\Entity]
#[ORM\EntityListeners([TemplateBlockListener::class, TranslateListener::class])]
class TemplateBlock implements ITemplate
{
	use TId;
	use TTranslateListener;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $title;

	/**
	 * @var Collection<string, TemplateBlockText>
	 */
	#[ORM\OneToMany(mappedBy: 'block', targetEntity: TemplateBlockText::class, indexBy: 'lang')]
	public Collection $texts;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $template;

	public function __construct(string $title, string $template)
	{
		$this->title    = $title;
		$this->template = $template;
		$this->texts    = new ArrayCollection;
	}

	public function setTexts($texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}

	public function getText($lang = null): ?TemplateBlockText { return $this->texts[$lang ?: $this->locale] ?? null; }

	/** @return array */
	public function getTexts() { return []; }
}
