<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'pages__template_page_group')]
#[ORM\Entity]
class TemplatePageGroup
{
	use TId;
	use TTranslateListener;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $title;

	/**
	 * @var Collection<TemplatePage>
	 */
	#[ORM\OneToMany(mappedBy: 'group', targetEntity: TemplatePage::class)]
	protected Collection $pages;

	public function __construct(string $title)
	{
		$this->title = $title;
		$this->pages = new ArrayCollection;
	}

	/**
	 * @return Collection<TemplatePage>
	 */
	protected function getBlocks() { return $this->pages; }
}
