<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Core\Model\Lang\Langs;
use Doctrine;
use Doctrine\ORM\Event\PostPersistEventArgs;
use Doctrine\ORM\Event\PostRemoveEventArgs;
use Doctrine\ORM\Event\PostUpdateEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Nette\Caching\Cache;
use Nette\Caching\Storage;
use Nette\SmartObject;
use Pages\FrontModule\Model\TemplatePages;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class TemplatePageListener implements EventSubscriberInterface
{
	use SmartObject;

	private Cache $cache;

	public function __construct(
		protected Storage $cacheStorage,
		protected Langs   $langs,
	)
	{
		$this->cache = new Cache($cacheStorage, TemplatePages::CACHE_NAMESPACE);
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PostPersist]
	#[ORM\PostUpdate]
	#[ORM\PostRemove]
	public function postHandler(TemplatePage $templatePage, PostPersistEventArgs|PostUpdateEventArgs|PostRemoveEventArgs $event): void
	{
		if ($templatePage->getId()) {
			foreach ($this->langs->getLangs(false) as $lang) {
				$this->cache->remove('templatePage/' . $templatePage->getId() . '/' . $lang->getTag());
			}
		}

		$this->cache->clean([
			Cache::Tags => [TemplatePages::CACHE_NAMESPACE],
		]);
	}

}
