<?php declare(strict_types = 1);

namespace Pages\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Core\Model\UI\Form\Controls\SelectInput;
use Navigations\AdminModule\Components\NavigationForm;
use Navigations\Model\NavigationConfig;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;
use Pages\AdminModule\Model\TemplatePages;
use Pages\Model\PagesConfig;

class TemplatePage extends BaseNavigation implements INavigationItem
{
	protected $title     = 'templatePage';
	protected $presenter = 'Pages:Front:Default';
	protected $action    = 'templatePage';

	protected ?string $navFormSite = null;

	public function __construct(protected TemplatePages $templatePagesService)
	{
	}

	public function navigationFormCustomHandle(NavigationForm $component, array $data = []): void
	{
		$this->navFormSite = $data['site'];
		$component->loadComponent($data['componentId']);
		$component->redrawControl('component');
	}

	public function getFormContainer(BaseForm $baseForm)
	{
		/** @var NavigationForm $navigationForm */
		$navigationForm = $baseForm->getParent();
		$container      = new BaseContainer;
		$site           = $this->navFormSite ?: $baseForm->getCustomData('loadComponent')['site'];
		$pages          = $this->templatePagesService->getOptionsForSelectGrouped();

		$container->addSelect('templatePage', 'pages.navigationForm.page', $pages)->setRequired();

		/** @var SelectInput $selectInputTemplatePage */
		$selectInputTemplatePage = $container['templatePage'];

		// TODO nejak zautomatizovat, stejne jako kategorie u eshopu
		if ($navigationForm->lookup(null, false)) {
			$componentId = $navigationForm->getParameter('componentId');
			if ($componentId) {
				$selectInputTemplatePage->setHtmlAttribute(
					'data-custom-link',
					$navigationForm->link('componentCustom!', [$componentId]),
				);
			}
		} else {
			$baseForm->onAnchor[] = static function() use ($baseForm, $navigationForm, $selectInputTemplatePage) {
				if ($baseForm->getValues()->componentType) {
					$selectInputTemplatePage->setHtmlAttribute(
						'data-custom-link',
						$navigationForm->link('componentCustom!', [$baseForm->getValues()->componentType]),
					);
				}
			};
		}

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		return $this->presenter == $presenter && $this->action == $action;
	}

	/**
	 * @param DaoNavigationItem $navigation
	 * @param array             $urlParams
	 */
	public function routerIn($navigation, $urlParams = []): ?array
	{
		if ($navigation->isHomepage && isset($urlParams['path']) && $urlParams['path'] !== '') {
			return null;
		}

		if ($urlParams['path'] &&
			!(PagesConfig::load('templatePage.checkExactUrlInNavigation', false)
				&& ($navigation->link !== '/' . $urlParams['path'] || $navigation->link !== '/' . $urlParams['locale'] . '/' . $urlParams['path']))) {
			$tmp = explode('/', (string) $urlParams['path']);

			if (end($tmp) !== $navigation->alias) {
				return null;
			}
		}

		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => $navigation->componentParams['templatePage'],
		];
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		if (isset($urlParams['presenter'], $urlParams['action']) && !$this->presenterActionCheck(
				$urlParams['presenter'],
				$urlParams['action'],
			)) {
			return null;
		}

		$return = $navigation->isHomepage ? '/' : '/' . $navigation->alias;

		if (NavigationConfig::load('urlSuffix')) {
			$return .= NavigationConfig::load('urlSuffix');
		}

		return $return;
	}
}
