<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\Helpers\Arrays;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\Controls\CheckboxListInput;
use Nette\Utils\Json;

class CheckboxList extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'checkboxList';

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		/** @var CheckboxListInput $c */
		$c = $formContainer->addCheckboxList($this->getName(), $this->getTitle(), $params['items'] ?? []);

		if (isset($params['default'])) {
			$formContainer->getComponent($this->getName())
				->setDefaultValue(
					Arrays::isJson($params['default']) ? Json::decode($params['default']) : $params['default'],
				);
		}

		if (isset($params['multiLang'])) {
			$c->setIsMultilanguage($params['multiLang']);
		}
	}

	public function render(array $params)
	{
		return $this->getDefault();
	}
}
