<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Contributte\Translation\Translator;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;

class Image extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'image';

	final public const PART_FILE  = 'file';
	final public const PART_TITLE = 'title';
	final public const PART_ALT   = 'alt';

	public function __construct(protected Translator $translator)
	{
	}

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$fileName  = $this->getName() . '_' . self::PART_FILE;
		$altName   = $this->getName() . '_' . self::PART_ALT;
		$titleName = $this->getName() . '_' . self::PART_TITLE;
		$container = $formContainer->addContainerWithLabel($this->getName(), $this->getTitle());
		$container->addCustomData('ttType', self::class);
		$file  = $container->addFilesManager($fileName, 'pages.templateTextType.image.file');
		$alt   = $container->addText($altName, 'pages.templateTextType.image.alt');
		$title = $container->addText($titleName, 'pages.templateTextType.image.title');

		if (isset($params['multiLang'])) {
			$container->addCustomData('multiLang', true);
			$file->setIsMultilanguage($params['multiLang']);
			$alt->setIsMultilanguage($params['multiLang']);
			$title->setIsMultilanguage($params['multiLang']);
		}

		$valFile  = [];
		$valAlt   = [];
		$valTitle = [];
		foreach ($texts as $key => $value) {
			$txt = $value->getTexts();

			if (isset(
				$txt[$this->getName() . '_' . self::PART_FILE], $txt[$this->getName(
				) . '_' . self::PART_ALT], $txt[$this->getName() . '_' . self::PART_TITLE],
			)) {
				$kFile    = $this->getName() . '_' . self::PART_FILE;
				$kAlt     = $this->getName() . '_' . self::PART_ALT;
				$kTitle   = $this->getName() . '_' . self::PART_TITLE;
				$valFile  = $txt[$kFile];
				$valAlt   = $txt[$kAlt];
				$valTitle = $txt[$kTitle];
			} else {
				$data = $txt[$this->getName()];
				if (!is_array($data)) {
					$valFile[$key] = $value->getText($this->getName());
				} else {
					$valFile[$key]  = $data[$fileName];
					$valAlt[$key]   = $data[$altName];
					$valTitle[$key] = $data[$titleName];
				}
			}
		}
		$file->setDefaultValue($valFile);
		if ($valAlt) {
			$alt->setDefaultValue($valAlt);
		}
		if ($valTitle) {
			$title->setDefaultValue($valTitle);
		}
	}

	public function render(array $params)
	{
		if (is_array($this->getDefault())) {
			$result = [
				self::PART_FILE  => $this->getDefault()[$params['name'] . '_' . self::PART_FILE],
				self::PART_ALT   => $this->getDefault()[$params['name'] . '_' . self::PART_ALT],
				self::PART_TITLE => $this->getDefault()[$params['name'] . '_' . self::PART_TITLE],
			];

			if ($params['multiLang'] === true) {
				$locale = $this->translator->getLocale();

				foreach ($result as &$v) {
					if (is_array($v) && isset($v[$locale])) {
						$v = $v[$locale];
					}
				}
			}

			return $result;
		}

		return [
			self::PART_FILE  => $this->getDefault(),
			self::PART_ALT   => '',
			self::PART_TITLE => '',
		];
	}
}
