<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Nette\InvalidArgumentException;

class SelectBox extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'selectBox';

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		if (!isset($params['items'])) {
			throw new InvalidArgumentException('Parameter \'items\' must by specified');
		}

		if (is_array($params['items'])) {
			$items = $params['items'];
		} else {
			$items = array_map('trim', explode(',', (string) $params['items']));
		}

		$c = $formContainer->addSelect($this->getName(), $this->getTitle(), $items);

		if (isset($params['default'])) {
			$formContainer->getComponent($this->getName())->setDefaultValue($params['default']);
		}

		if (isset($params['multiLang'])) {
			$c->setIsMultilanguage($params['multiLang']);
		}
	}

	public function render(array $params)
	{
		return $this->getDefault();
	}

}
