<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;

class Text extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'text';

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$c = $formContainer->addText($this->getName(), $this->getTitle());
		if (isset($params['multiLang'])) {
			$c->setIsMultilanguage($params['multiLang']);
		}
	}

	public function render(array $params)
	{
		return $this->getDefault();
	}
}
