<?php declare(strict_types = 1);

namespace PayPal\DI;

use Core\DI\CompilerExtension;
use PayPal\FrontModule\Model\Paypal;
use Nette\DI\Definitions\ServiceDefinition;
use Nette\PhpGenerator\ClassType;

class PaypalExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['PayPal' => 'PayPal\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();


		$paypalKey = 'paypal.paypal';
		/** @var ServiceDefinition|null $paypal */
		$paypal = $builder->getDefinition($paypalKey);
		if ($paypal) {
			$originalArguments = $paypal->factory->arguments;
			$builder->removeDefinition($paypalKey);
			$builder->addDefinition($paypalKey)
				->setFactory(Paypal::class, [
					$builder->literal('$this->parameters["paypal"]'),
					'@core.sites',
					...$originalArguments,
				])
				->setAutowired(false);
		}
	}

	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init    = $class->methods['initialize'];
		$builder = $this->getContainerBuilder();

		$init->addBody('PayPal\Model\PaypalConfig::setParams($this->parameters[\'paypal\']);');
	}
}
