<?php declare(strict_types = 1);

namespace PayPal\FrontModule\Model\Subscribers;

/*use Brick\Money\Money;
use ComGate\FrontModule\Components\ComgateControl;
use ComGate\FrontModule\Components\IComgateControlFactory;
use ComGate\FrontModule\Model\Comgate;
use ComGate\FrontModule\Model\Exceptions\ComgateException;
use Contributte\Comgate\Entity\Codes\PaymentMethodCode;
use Contributte\Comgate\Entity\Payment;
use Contributte\Comgate\Entity\PaymentStatus;
use Contributte\Comgate\Gateway\PaymentService;
use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Event\PresenterTemplateEvent;
use EshopOrders\FrontModule\Model\CardsPaymentService;
use EshopOrders\FrontModule\Presenters\FinishedPresenter;
use EshopOrders\FrontModule\Presenters\PaymentPresenter;
use EshopOrders\Model\Entities\OrderItem;
use EshopOrders\Model\Orders;
use Gls\Model\Exception;*/
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Tracy\Debugger;

class OrderPaymentSubscriber implements EventSubscriberInterface
{
	/*protected IComgateControlFactory $comgateControlFactory;
	protected PaymentService $paymentService;
	protected CardsPaymentService $cardsPaymentService;
	protected EntityManagerDecorator $em;
	protected Orders $orders;*/

	/*public function __construct(IComgateControlFactory $comgateControlFactory, PaymentService $paymentService,
	                            CardsPaymentService    $cardsPaymentService, Orders $orders, EntityManagerDecorator $em)
	{
		$this->comgateControlFactory = $comgateControlFactory;
		$this->paymentService        = $paymentService;
		$this->cardsPaymentService   = $cardsPaymentService;
		$this->orders                = $orders;
		$this->em                    = $em;
	}*/

	/**
	 * @return string[]
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderFinishedRender'   => 'orderFinishedRender',
			//'eshopOrders.paymentPayAction'      => 'paymentPayAction',
			//'eshopOrders.paymentFinishedRender' => 'paymentFinishedRender',
		];
	}

	/**
	 * @param PresenterTemplateEvent $event
	 */
	public function orderFinishedRender(PresenterTemplateEvent $event): void
	{
		/** @var FinishedPresenter $presenter */
		$presenter = $event->presenter;
		$order     = $presenter->order;

		if (!$order || $order->getPayment()->getPayment()->getIdent() !== 'card' || $order->getPayment()->getPayment()->code1 !== 'paypal') {
			return;
		}

		$presenter->template->link = $presenter->link('Payment:pay', ['orderIdent' => $order->getIdent()]);
		$presenter->addIncludeTemplate(__DIR__ . '/PaypalButton.latte');
	}

	public function _paymentPayAction(PresenterTemplateEvent $event): void
	{
		/** @var PaymentPresenter $presenter */
		$presenter = $event->presenter;
		$order     = $presenter->order;
		$self      = $this;

		$token = $this->cardsPaymentService->getLastCreated($order->getId()) ?: $this->cardsPaymentService->createToken($order);

		if ($token->param) {
			header("Location: " . Comgate::getPaymentUrl($token->param));
			exit;
		}

		$email = $order->getAddressInvoice() ? $order->getAddressInvoice()->getEmail() : null;
		if (!$email && $order->getAddressDelivery()) {
			$email = $order->getAddressDelivery()->getEmail();
		}

		if (!$email && $order->getCustomer()) {
			$email = $order->getCustomer()->getUser()->getEmail();
		}

		switch ($order->getPayment()->payment->code1) {
			case 'laterOnline':
				$method = 'LATER_ALL';
				break;
			case 'laterTwistoOnline':
				$method = 'LATER_TWISTO';
				break;
			case 'partOnline':
				$method = 'PART_ALL';
				break;
			case 'partTwistoOnline':
				$method = 'PART_TWISTO';
				break;
			case 'loanOnline':
				$method = 'LOAN_COFIDIS';
				break;
			default:
				$method = 'CARD_CZ_CSOB_2';
				break;
		}

		$payment = Payment::of(
			Money::of(round($order->getPrice(true), 2), $order->getCurrencyCode()),
			implode(', ', array_map(
					fn(OrderItem $orderItem): string => $orderItem->getOrderItemText()->getName(),
					$order->getOrderItems()->toArray())
			),
			(string) $order->getId(),
			$email,
			$method
		);

		$control = $this->comgateControlFactory->create($payment);

		$presenter->addComponent($control, 'comGateButton');

		$control->onCheckout[] = static function(ComgateControl $control, Payment $payment, $data) use ($token, $self) {
			$token->param = $data['transId'];
			$self->em->persist($token);
			$self->em->flush($token);
			$self->cardsPaymentService->tokenCheckout($token->getId());
		};

		$control->handleCheckout();
	}

	/**
	 * @param PresenterTemplateEvent $event
	 */
	public function _paymentFinishedRender(PresenterTemplateEvent $event): void
	{
		/** @var PaymentPresenter $presenter */
		$presenter = $event->presenter;
		$self      = $this;
		$params    = $presenter->getParameters();
		$transId   = $params['transId'] ?: $presenter->getHttpRequest()->getPost('transId');
		$orderId   = $params['orderId'] ?: $presenter->getHttpRequest()->getPost('orderId');
		$status    = null;
		$msg       = null;
		Debugger::log($presenter->getHttpRequest()->getPost(), '_comgate-full-post');

		if (!$transId) {
			try {
				$input = file_get_contents('php://input');
				Debugger::log($input, '_comgate-full-php-input');
				parse_str($input, $res);

				$transId = (int) $res['transId'];
				$orderId = $res['refId'] ?? null;
				$status  = $res['status'] ?? null;
				$msg     = $res['message'] ?? null;
				Debugger::log($res, '_comgate-full-php-input');
			} catch (\Exception $e) {
			}
		}

		if ($transId) {
			$order = $this->orders->get((int) $orderId);

			if (!$order || $order->getPayment()->getPayment()->getIdent() !== 'card')
				return;

			$presenter->order           = $order;
			$presenter->template->order = $order;

			$response = !$status ? $this->paymentService->status(PaymentStatus::of($transId)) : null;
			$token    = $this->cardsPaymentService->getLastCreated($order->getId());
			try {
				Debugger::log($response->getData(), '_comgate-full-response');
			} catch (\Exception$e) {
				Debugger::log($response, '_comgate-full-response');
			}

			if ($status && $status === 'PAID' || $response && $response->isOk() && $response->getData()['status'] === 'PAID') {
				if ($token)
					$self->cardsPaymentService->tokenPaid($token->getToken());
			} else {
				if (!$msg && $response)
					$msg = $response->getData()['message'] ?? null;
				Debugger::log(new ComgateException($msg ?? ''), 'comgate');
				if (!$status || $status !== 'PENDING')
					$self->cardsPaymentService->tokenError($token, $msg);
				$presenter->template->cardError = $msg ?: $status;
			}
		}

		$presenter->addIncludeTemplate(__DIR__ . '/PaymentFinished.latte');
	}
}
