<?php declare(strict_types = 1);

namespace PayPal\DI;

use Core\DI\CompilerExtension;
use Nette\PhpGenerator\ClassType;
use Override;
use PayPal\FrontModule\Model\Paypal;

class PaypalExtension extends CompilerExtension
{

	#[Override]
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['Paypal' => 'PayPal\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();
		$key     = 'paypal.paypal';
		$builder->addDefinition($key)
			->setFactory(Paypal::class, [
				$builder->literal('$this->parameters["paypal"]'),
				'@core.sites',
			])
			->setAutowired(true);
	}

	#[Override]
	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init = $class->getMethod('initialize');

		$init->addBody('PayPal\Model\PaypalConfig::setParams($this->parameters[\'paypal\']);');
	}

}
