<?php declare(strict_types = 1);

namespace PayPal\FrontModule\Components;

use Closure;
use Core\Model\UI\BaseControl;
use EshopOrders\Model\Entities\Order;
use Exception;
use Nette\Application\UI\InvalidLinkException;
use PayPal\FrontModule\Model\Paypal;
use PayPal\FrontModule\Service\PaymentService;
use ReflectionException;

//use PayPal\FrontModule\Model\ResponseFactory;


class PaypalControl extends BaseControl
{
	/** @var Closure[] */
	public array $onCheckout = [];

	/** @var Closure[] */
	public array $onSuccess = [];

	/** @var Closure[] */
	public array $onError = [];

	public function __construct(
		protected PaymentService $paymentService,
		protected Paypal         $paypal,
	)
	{
	}

	/**
	 * @throws InvalidLinkException
	 * @throws ReflectionException
	 */
	public function render(array $attrs = [], string $text = 'Pay'): void
	{
		//var_dump($this->link('//checkout!'));
		$template = $this->template;
		$template->setFile($this->getTemplateFile());
		$template->add('checkoutLink', $this->link('//checkout!'));
		$template->add('attrs', $attrs);
		$template->add('text', $text);
		$template->render();
	}

	public function handleCheckout(): void
	{
		/*$res = $this->paymentService->create($this->payment);
		$data = $res->getData();

		if ($res->isOk() && isset($data['redirect'])) {

			$url = $data['redirect'];
			$this->onCheckout($this, $this->payment, $data);

			$presenter = $this->getPresenter();
			$presenter->redirectUrl($url);
		}*/
		//var_dump($this->link('//checkout!'));
	}

	public function createPayment(Order $order): string
	{
		return $this->paymentService->create($this->paypal, $order);
	}

	public function capturePayment(string $paypalID): array
	{
		return $this->paymentService->capture($this->paypal, $paypalID);
	}

	public function errorHandler(Exception $exception, mixed $response = null): void
	{
		if (!$this->onError) {
			throw $exception;
		}

		$this->onError($this, $exception, $response);
	}

}
