<?php declare(strict_types = 1);

namespace PayPal\FrontModule\Service;

use EshopOrders\Model\Entities\Order;
use Nette\Utils\Json;
use PayPal\FrontModule\Model\Paypal;

class PaymentService
{

	public function create(Paypal $paypal, Order $order): string
	{
		$acctoken = $this->generateToken($paypal);
		if ($acctoken) {
			$content = [
				'intent'         => 'CAPTURE',
				'purchase_units' => [
					[
						'amount' => [
							'currency_code' => $order->getCurrencyCode(),
							'value'         => $order->getPrice(true),
						],
					],
				],
			];
			$ch      = curl_init();
			$headr   = ['Authorization: Bearer ' . $acctoken];
			$headr[] = 'Content-type: application/json';
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headr);
			curl_setopt($ch, CURLOPT_URL, $paypal->getCheckoutURL());
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, Json::encode($content));
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			$resp = curl_exec($ch);
			curl_close($ch);
			if ($resp) {
				$data = (array) Json::decode((string) $resp, forceArrays: true);

				if (isset($data['id']) && $data['status'] == 'CREATED') {
					return (string) $data['id'];
				}
			}
		}

		return '';
	}

	public function capture(Paypal $paypal, string $paypalID): array
	{
		$acctoken = $this->generateToken($paypal);

		if ($acctoken) {
			$ch      = curl_init();
			$headr   = ['Authorization: Bearer ' . $acctoken];
			$headr[] = 'Content-type: application/json';
			$headr[] = 'Content-Length: 0';
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headr);
			curl_setopt($ch, CURLOPT_URL, $paypal->getCaptureURL($paypalID));
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
			$resp = curl_exec($ch);
			curl_close($ch);
			if ($resp) {
				return (array) Json::decode((string) $resp, forceArrays: true);
			}
		}

		return [];
	}

	protected function generateToken(Paypal $paypal): string
	{
		$ch    = curl_init();
		$headr = ['Authorization: Basic ' . base64_encode($paypal->getClientID() . ':' . $paypal->getSecret())];
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headr);
		curl_setopt($ch, CURLOPT_URL, $paypal->getTokenURL());
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, 'grant_type=client_credentials');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$resp = curl_exec($ch);
		curl_close($ch);
		if ($resp) {
			$data = (array) Json::decode((string) $resp, forceArrays: true);

			return (string) $data['access_token'];
		}

		return '';
	}
}
