<?php declare(strict_types=1);

namespace PayPal\FrontModule\Components;

use Closure;
use EshopOrders\Model\Entities\Order;
//use PayPal\FrontModule\Model\ResponseFactory;
use PayPal\FrontModule\Service\PaymentService;
use PayPal\FrontModule\Model\Paypal;
use Core\Model\UI\BaseControl;


class PaypalControl extends BaseControl
{
	/** @var Closure[] */
	public array $onCheckout = [];

	/** @var Closure[] */
	public array $onSuccess = [];

	/** @var Closure[] */
	public array $onError = [];

	protected PaymentService $paymentService;
	protected Paypal $paypal;

	public function __construct(PaymentService $paymentService, Paypal $paypal)
	{
		$this->paypal = $paypal;
		$this->paymentService = $paymentService;
	}

	/**
	 * @throws \Nette\Application\UI\InvalidLinkException
	 * @throws \ReflectionException
	 */
	public function render(array $attrs = [], string $text = 'Pay'): void
	{
        //var_dump($this->link('//checkout!'));
		$template = $this->template;
		$template->setFile($this->getTemplateFile());
		$template->add('checkoutLink', $this->link('//checkout!'));
		$template->add('attrs', $attrs);
		$template->add('text', $text);
		$template->render();
	}

	public function handleCheckout(): void
	{
		/*$res = $this->paymentService->create($this->payment);
		$data = $res->getData();

		if ($res->isOk() && isset($data['redirect'])) {

			$url = $data['redirect'];
			$this->onCheckout($this, $this->payment, $data);

			$presenter = $this->getPresenter();
			$presenter->redirectUrl($url);
		}*/
        //var_dump($this->link('//checkout!'));
	}

    public function createPayment(Order $order): string
    {
        return $this->paymentService->create($this->paypal, $order);
    }

	public function capturePayment(string $paypalID): array
	{
        return $this->paymentService->capture($this->paypal, $paypalID);
	}

	public function errorHandler(\Exception $exception, $response = null): void
	{
		if (!$this->onError) {
			throw $exception;
		}

		$this->onError($this, $exception, $response);
	}

}
