<?php declare(strict_types = 1);

namespace PayPal\FrontModule\Service;

use EshopOrders\Model\Entities\Order;
use PayPal\FrontModule\Model\Paypal;
use Tracy\Debugger;

class PaymentService {

	public function create(Paypal $paypal, Order $order)
	{
        $acctoken = $this->generateToken($paypal);
        if($acctoken) {
            $content = array(
                'intent' => 'CAPTURE',
                'purchase_units' => array(
                    array(
                        'amount' => array(
                            'currency_code' => $order->getCurrencyCode(),
                            'value' => $order->getPrice(true)
                        )
                    )
                )
            );
            $ch = curl_init();
            $headr = array('Authorization: Bearer ' . $acctoken);
            $headr[] = 'Content-type: application/json';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headr);
            curl_setopt($ch, CURLOPT_URL, $paypal->getCheckoutURL());
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($content));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $resp = curl_exec($ch);
            curl_close($ch);
            if($resp) {
                $data = json_decode($resp, true);
				$status = (string) $data['status'];

                if(isset($data['id']) && $status === 'CREATED') {
                    return (string) $data['id'];
                } else {
	                Debugger::log(json_encode($content), 'paypal-error');
	                Debugger::log($resp, 'paypal-error');
                }
            }
        }

        return '';
    }

	public function capture(Paypal $paypal, string $paypalID)
	{
        $acctoken = $this->generateToken($paypal);
        //var_dump($acctoken);
        if($acctoken) {
            $ch = curl_init();
            $headr = array('Authorization: Bearer ' . $acctoken);
            $headr[] = 'Content-type: application/json';
			$headr[] = 'Content-Length: 0';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headr);
            curl_setopt($ch, CURLOPT_URL, $paypal->getCaptureURL($paypalID));
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            $resp = curl_exec($ch);
            curl_close($ch);
            if($resp) {
	            $data = json_decode($resp, true);
	            return $data;
            }
        }

        return array();
    }

    protected function generateToken(Paypal $paypal)
	{
        $ch = curl_init();
        $headr = array('Authorization: Basic ' . base64_encode($paypal->getClientID() . ':' . $paypal->getSecret()));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headr);
        curl_setopt($ch, CURLOPT_URL, $paypal->getTokenURL());
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'grant_type=client_credentials');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $resp = curl_exec($ch);
        curl_close($ch);
        if($resp) {
            $data = json_decode($resp, true);
            return $data['access_token'];
        }
        return '';
    }


}
