<?php declare(strict_types = 1);

namespace PayPal\DI;

use Core\DI\CompilerExtension;
use PayPal\FrontModule\Model\Paypal;
//use Nette\DI\Definitions\ServiceDefinition;
use Nette\PhpGenerator\ClassType;

class PaypalExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Paypal' => 'PayPal\*Module\Presenters\*Presenter']);

        $builder = $this->getContainerBuilder();
        $key = 'paypal.paypal';
        $builder->addDefinition($key)
				->setFactory(Paypal::class, [
					$builder->literal('$this->parameters["paypal"]'),
					'@core.sites'
				])
				->setAutowired(true);
	}

	public function afterCompile(ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->methods["initialize"];

		$init->addBody('PayPal\Model\PaypalConfig::setParams($this->parameters[\'paypal\']);');
	}

}
