<?php declare(strict_types = 1);

namespace PayPal\FrontModule\Model;

use Core\Model\Sites;

class Paypal {

    protected static string $pathToken = '/v1/oauth2/token';
    protected static string $pathCheckout = '/v2/checkout/orders';
    protected static string $pathCapture = '/v2/checkout/orders/%s/capture';

    protected static string $sdkURL = 'https://www.paypal.com/sdk/js?client-id=%s&enable-funding=credit&currency=%s';

	protected Sites $sites;

	protected ?array $config;

	/**
	 * @param mixed $args
	 */
	public function __construct(?array $config, Sites $sites)
	{
		$this->config = $config;
		$this->sites  = $sites;
	}

	public function getClientID(): string
	{
		$config = $this->getConfig();

		return $config ? $config['clientID'] : '';
	}

	public function getSecret(): string
	{
		$config = $this->getConfig();

		return $config ? $config['secret'] : '';
	}

	public function getGatewayURL(): string
	{
		$config = $this->getConfig();

        if($config) {
            if($config['test']) return $config['gatewayURL']['sandbox'];
            else return $config['gatewayURL']['live'];
        }

        return '';
	}

	protected function getConfig(): ?array
	{
		$currentSite = $this->sites->getCurrentSite();
		$siteConfig  = $this->config[$currentSite->getIdent()] ?? null;
		$config      = null;

		if ($siteConfig) {
			$config = $siteConfig[$currentSite->getCurrentDomain()->getLang()] ?? $siteConfig;
		}
        else {
            $config = $this->config;
        }

		return $config;
	}

	public function getTokenURL(): string {
        return $this->getGatewayURL() . self::$pathToken;
    }

	public function getCheckoutURL(): string {
        return $this->getGatewayURL() . self::$pathCheckout;
    }

	public function getCaptureURL(string $param): string {
        return $this->getGatewayURL() . sprintf(self::$pathCapture, $param);
    }

	public function getSDKURL(string $param): string {
        return sprintf(self::$sdkURL, $this->getClientID(), $param);
    }
}
