<?php declare(strict_types = 1);

namespace PayPal\FrontModule\Service;

use EshopOrders\Model\Entities\Order;
use PayPal\FrontModule\Model\Paypal;

class PaymentService {

	public function create(Paypal $paypal, Order $order)
	{
        $acctoken = $this->generateToken($paypal);
        //var_dump($acctoken);
        if($acctoken) {
            $content = array(
                'intent' => 'CAPTURE',
                'purchase_units' => array(
                    array(
                        'amount' => array(
                            'currency_code' => $order->getCurrencyCode(),
                            'value' => $order->getPrice()
                        )
                    )
                )
            );
            $ch = curl_init();
            $headr = array('Authorization: Bearer ' . $acctoken);
            $headr[] = 'Content-type: application/json';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headr);
            curl_setopt($ch, CURLOPT_URL, $paypal->getCheckoutURL());
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($content));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $resp = curl_exec($ch);
            curl_close($ch);
            if($resp) {
                $data = json_decode($resp, true);
                //var_dump($data);
                if(isset($data['id']) && $data['status'] == 'CREATED') {
                    return (string) $data['id'];
                }
            }
        }

        return '';
    }

	public function capture(Paypal $paypal, string $paypalID)
	{
        $acctoken = $this->generateToken($paypal);
        //var_dump($acctoken);
        if($acctoken) {
            $ch = curl_init();
            $headr = array('Authorization: Bearer ' . $acctoken);
            $headr[] = 'Content-type: application/json';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headr);
            curl_setopt($ch, CURLOPT_URL, $paypal->getCaptureURL($paypalID));
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $resp = curl_exec($ch);
            curl_close($ch);
            if($resp) {
                $data = json_decode($resp, true);
                return $data;
            }
        }

        return array();
    }

    protected function generateToken(Paypal $paypal)
	{
        $ch = curl_init();
        $headr = array('Authorization: Basic ' . base64_encode($paypal->getClientID() . ':' . $paypal->getSecret()));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headr);
        curl_setopt($ch, CURLOPT_URL, $paypal->getTokenURL());
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'grant_type=client_credentials');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $resp = curl_exec($ch);
        curl_close($ch);
        if($resp) {
            $data = json_decode($resp, true);
            return $data['access_token'];
        }
        return '';
    }


}
