<?php declare(strict_types = 1);

namespace Ppl\DI;

use Core\DI\CompilerExtension;
use Nette;

class PplExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Ppl' => 'Ppl\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init = $class->methods["initialize"];

		$init->addBody('Ppl\Model\PplConfig::setParams($this->parameters[\'pplData\']);');
	}
}
