document.addEventListener('click', e => {
	const target = e.target;

	if (target.dataset.pplChoosePickupPoint !== undefined) {
		const popup = document.createElement('div');
		popup.setAttribute('data-input', target.id);
		popup.setAttribute('id', 'pplIframePopup');
		popup.setAttribute('style', 'z-index: 999999; position: fixed; -webkit-backface-visibility: hidden; left: 0; top: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.3);');

		const wrap = document.createElement('div');
		wrap.setAttribute('style', 'position: absolute; left: 0px; top: 0px; width: 100%; height: 100%; padding: 1rem .7rem;');

		const head = document.createElement('div');
		head.setAttribute('style', 'text-align: right; padding: 1rem; height: 4rem; background-color: #004B93');
		head.classList.add('primary-bg-color');

		const close = document.createElement('a');
		close.setAttribute('href', 'javascript:;');
		close.setAttribute('style', 'cursor: pointer; display: inline-block;');
		close.innerHTML = '<i class="ppl-popup-cloe" style="fill: #fff; width: 2rem; height: 2rem;" data-svg-icon-pshk="close"></i>';
		close.addEventListener('click', e => {
			popup.remove();
		});

		head.appendChild(close);
		wrap.appendChild(head);

		var link  = document.createElement("link");
		link.rel  = "stylesheet";
		link.href = "https://www.ppl.cz/sources/map/main.css";

		// Create a script element to load the main.js file
		var script = document.createElement("script");
		script.src = "https://www.ppl.cz/sources/map/main.js";

		var style = document.createElement("style");
		style.innerHTML = `
			#ppl-parcelshop-map > div {max-height: calc(100vh - 6rem) !important;}	
			.ppl-popup-cloe svg {width: inherit; height: inherit;}
		`;
		document.head.appendChild(style);

		// Add the script+href link to the document head
		document.head.appendChild(link);
		document.head.appendChild(script);

		const iframe = document.createElement('div');
		iframe.setAttribute('id', 'ppl-parcelshop-map');
		iframe.setAttribute('data-language', document.documentElement.lang);
		iframe.setAttribute('data-country', target.dataset.country.toUpperCase());
		iframe.setAttribute('style', 'height: 85vh;')
		wrap.appendChild(iframe);

		popup.appendChild(wrap);

		document.body.appendChild(popup);

		document.dispatchEvent(new Event('loadSvgIcons'));
	}
});

document.addEventListener(
	"ppl-parcelshop-map",
	(event) => {
		const iframePopup = document.getElementById('pplIframePopup');
		if (!iframePopup) {
			return;
		}

		const inputPlaceholder = document.getElementById(iframePopup.dataset.input);
		inputPlaceholder.value = event.detail.name + ' - ' + event.detail.street + ', ' + event.detail.city;

		const inputTarget = document.getElementById(inputPlaceholder.dataset.target);
		inputTarget.value = event.detail.code;
		const inputStreet = document.getElementById(inputPlaceholder.dataset.street);
		inputStreet.value = event.detail.street;
		const inputCity   = document.getElementById(inputPlaceholder.dataset.city);
		inputCity.value   = event.detail.city;
		const inputPostal = document.getElementById(inputPlaceholder.dataset.postal);
		inputPostal.value = event.detail.zipCode;

		iframePopup.remove();
	}
);
// window.addEventListener('message', e => {
// 	const ps = e.data.parcelshop;
//
// 	if (ps === undefined || !ps.detail || !ps.detail.pclshopid)
// 		return;
//
// 	const iframePopup = document.getElementById('myGlsIframePopup');
// 	if (!iframePopup)
// 		return;
//
// 	const inputPlaceholder = document.getElementById(iframePopup.dataset.input);
// 	inputPlaceholder.value = ps.detail.name + ' - ' + ps.detail.address + ' ' + ps.detail.city;
//
// 	const inputTarget = document.getElementById(inputPlaceholder.dataset.myglsPickupTrigger);
// 	inputTarget.value = ps.detail.pclshopid;
// 	const inputStreet = document.getElementById(inputPlaceholder.dataset.street);
// 	inputStreet.value = ps.detail.address;
// 	const inputCity   = document.getElementById(inputPlaceholder.dataset.city);
// 	inputCity.value   = ps.detail.city;
// 	const inputPostal = document.getElementById(inputPlaceholder.dataset.postal);
// 	inputPostal.value = ps.detail.zipcode;
//
// 	iframePopup.remove();
// });
