<?php declare(strict_types = 1);

namespace Ppl\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ppl__parcel_number")
 * @ORM\Entity
 */
class PplParcelNumber
{
	use TId;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $numberPackage;

	/**
	 * @ORM\ManyToOne(targetEntity="PplOrder", inversedBy="associatedNumberPackages")
	 * @ORM\JoinColumn(name="parcel_order_id", referencedColumnName="order_id", nullable=false, onDelete="CASCADE")
	 */
	protected PplOrder $parcelOrder;

	public function __construct(string $numberPackage, PplOrder $parcelOrder)
	{
		$this->numberPackage = $numberPackage;
		$this->parcelOrder   = $parcelOrder;
	}

	public function getNumberPackage(): string
	{
		return $this->numberPackage;
	}

}
