<?php declare(strict_types = 1);

namespace Ppl\Model\Subscribers;

use Core\Model\Event\Event;
use EshopOrders\AdminModule\Model\Statuses;
use Ppl\Model\ApiService;
use Ppl\Model\OrdersExported;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderSubscriber implements EventSubscriberInterface
{
	protected OrdersExported $ordersExported;
	protected ApiService     $apiService;
	protected Statuses       $statuses;

	public function __construct(OrdersExported $ordersExported, ApiService $apiService, Statuses $statuses)
	{
		$this->ordersExported = $ordersExported;
		$this->apiService     = $apiService;
		$this->statuses       = $statuses;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orders.checkCompleted' => 'checkCompleted',
		];
	}

	public function checkCompleted(Event $event): void
	{
		//		$orders = $this->ordersExported->getOrdersNotCompleted();
		//
		//		$completed = [];
		//		foreach ($orders as $id => $go) {
		//			if ($this->orderApiService->checkCompleted($go))
		//				$completed[] = $id;
		//		}
		//
		//		if (!empty($completed)) {
		//			try {
		//				$result = $this->statuses->changeStatus($completed, OrderStatus::STATUS_FINISHED);
		//
		//				if ($result)
		//					$this->ordersExported->markAsCompleted($completed);
		//			} catch (\Exception$e) {
		//				Debugger::log('MY GLS error - ' . $e->getMessage(), 'ordersCheckComplete');
		//				Debugger::log($e);
		//			}
		//		}
		//
		//		$this->ordersExported->em->clear();
	}
}
