<?php declare(strict_types=1);

namespace Questions\AdminModule\Components\Answer;

use Core\Model\UI\Form\BaseForm;
use Core\Model\UI\BaseControl;
use Nette\Utils\ArrayHash;
use Nette\Utils\Json;
use Questions\Model\Entities\Answer;
use Questions\Model\Entities\Question;
use Questions\Model\Questions;
use SimpleProducts\Model\Entities\Product;
use SimpleProducts\Model\SimpleProducts;

class AnswerForm extends BaseControl
{
	/** @var Question */
	protected $question;

	/** @var Questions */
	protected $questionsService;

	/** @var SimpleProducts */
	protected $productsService;

	public function __construct(Questions $questionsService, SimpleProducts $simpleProducts)
	{
		$this->questionsService = $questionsService;
		$this->productsService = $simpleProducts;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$products = [];
		foreach ($this->productsService->getAll() as $p) {
			$products[$p->id] = $p->title;
		}

		$form->addTextArea('answer', 'questions.answerForm.answer')->setRequired();
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);
		$form->addEditor('recommendation', 'questions.answerForm.recommendation')->setHeight(100);
		$form->addText('score', 'questions.answerForm.score')->setType('number')->setDefaultValue(0);
		$form->addText('class', 'questions.answerForm.class');
		$form->addSelect('assignedProducts', 'questions.answerForm.assignedProducts', $products);
		$form->addText('productScore', 'questions.answerForm.assignedProductsScore')->setDefaultValue(1);
		$form->addHidden('productsField', 'questions.answerForm.products')->setHtmlId("productsField");
		$form->addSubmit('submit', 'questions.answerForm.saveAnswer');
		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}


	public function setQuestion($id)
	{
		$this->question = $this->questionsService->get($id);
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			if ($this->question) {
				$question = $this->question;

				$answer = new Answer($values->answer, $question, $values->score);
				$answer->setParam('recommendation', $values->recommendation);
				$answer->answerClass = $values->class;

				if (!empty($values->productsField)) {
					$products = Json::decode($values->productsField);
					$productsToSave = [];
					foreach ($products as $product) {
						$productsToSave[$product->id] = $product;
					}
					$answer->setParam('products', $productsToSave);
				}

				$this->em->persist($answer)->flush();
			}

		} catch (\Exception $e) {
			$form->addError($e->getMessage());
			return false;
		}
	}

}
