<?php declare(strict_types=1);

namespace Questions\AdminModule\Presenters;

use Nette\Http\IResponse;
use Questions\AdminModule\Components\Answer\IAnswerFormFactory;
use Questions\AdminModule\Components\Answer\IAnswersGridFactory;
use Questions\AdminModule\Components\Categories\ICategoriesGridFactory;
use Questions\AdminModule\Components\Categories\ICategoryFormFactory;
use Questions\AdminModule\Components\Answer\IEditAnswerFormFactory;
use Questions\AdminModule\Components\Products\IProductsGridFactory;
use Questions\AdminModule\Components\Question\IQuestionFormFactory;
use Questions\AdminModule\Components\Question\IQuestionsGridFactory;
use Questions\Model\Entities\Answer;
use Questions\Model\Entities\Category;
use Questions\Model\Entities\Question;

final class DefaultPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('questions.title.questions'));
		$this->setHeader('questions.title.questions', 'fas fa-question');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'questions.menu.addCategory',
				'link' => 'Default:addCategory',
				'ico' => 'plus',
			], [
				'title' => 'questions.menu.addQuestion',
				'link' => 'Default:addQuestion',
				'ico' => 'plus',
			],
		]]);
	}

	public function actionAddCategory()
	{
		$this->setTitle($this->translator->translate('questions.title.addCategory'));
		$this->setHeader('questions.title.addCategory', 'fas fa-question');
	}

	public function actionAddQuestion()
	{
		$this->setTitle($this->translator->translate('questions.title.addQuestion'));
		$this->setHeader('questions.title.addQuestion', 'fas fa-question');
	}

	public function actionEditCategory($id)
	{
		$category = $this->em->getRepository(Category::class)->find($id);

		if (!$category)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('questions.title.editCategory'));
		$this->setHeader('questions.title.editCategory', 'fas fa-question');
	}

	public function actionEditQuestion($id)
	{
		$question = $this->em->getRepository(Question::class)->find($id);

		if (!$question)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('questions.title.editQuestion'));
		$this->setHeader('questions.title.editQuestion', 'fas fa-question');
	}

	public function actionEditAnswer($id)
	{
		$answer = $this->em->getRepository(Answer::class)->find($id);
		if (!$answer)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('questions.title.editAnswer'));
		$this->setHeader('questions.title.editAnswer', 'fas fa-question');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */
	protected function createComponentCategoryForm(ICategoryFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setCategory($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function () {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentCategoriesGrid(ICategoriesGridFactory $factory)
	{

		return $factory->create();
	}

	protected function createComponentAnswersGrid(IAnswersGridFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id')) {
			$control->setQuestion($this->getParameter('id'));
		}

		return $control;
	}

	protected function createComponentAnswerForm(IAnswerFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id')) {
			$control->setQuestion($this->getParameter('id'));
		}

		$control['form']->onSuccess['redirect'] = function () {
			$this->redirect('this');
		};

		return $control;
	}


	protected function createComponentQuestionsGrid(IQuestionsGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentQuestionForm(IQuestionFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setQuestion($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function () {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentEditAnswerForm(IEditAnswerFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setAnswer($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function () use ($control) {

			$this->redirect('editQuestion', $control->getAnswer()->question->getId());
		};

		return $control;
	}

	protected function createComponentProductsGrid(IProductsGridFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setAnswer($this->getParameter('id'));


		return $control;
	}


}