<?php declare(strict_types = 1);

namespace Questions\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;

class Answer
{
	use MagicAccessors {
		__get as MA__get;
	}

	/** @var int */
	public $id;

	/** @var string */
	public $answer;

	/** @var int */
	public $isPublished;

	/** @var float */
	public $score;

	/** @var string */
	public $class;

	/** @var Question */
	public $question;

	/** @var array */
	public $params;


	public function setId(int $id): Answer
	{
		$this->id = $id;
		return $this;
	}

	public function setAnswer(string $answer): Answer
	{
		$this->answer = $answer;
		return $this;
	}

	public function setIsPublished(int $isPublished): Answer
	{
		$this->isPublished = $isPublished;
		return $this;
	}

	public function setScore(float $score): Answer
	{
		$this->score = $score;
		return $this;
	}


	public function setQuestion($question): Answer
	{
		$this->question = $question;
		return $this;
	}

	/**
	 * @param string $class
	 */
	public function setClass($class)
	{
		$this->class = $class;
		return $this;
	}

	public function getHtml() {

	}

	/**
	 * @param array $params
	 */
	public function setParams($params): Answer
	{
		$this->params = $params;
		return $this;
	}


	public function &__get($name)
	{
		return $this->params[$name] ?? $this->MA__get($name);
	}


}