<?php declare(strict_types = 1);

namespace Questions\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;

class Category
{

	use MagicAccessors;

	/** @var int */
	public $id;

	/** @var string */
	public $title;

	/** @var Question[] */
	public $questions;

	/** @var int */
	public $isPublished;

	/** @var Category[] */
	public $child;

	/** @var Category */
	public $parent;

	/** @var string */
	public $class;

	public function setId(int $id): Category
	{
		$this->id = $id;
		return $this;
	}




	public function setTitle(string $title): Category
	{
		$this->title = $title;
		return $this;
	}


	public function setQuestions(array $questions): Category
	{
		$this->questions = $questions;
		return $this;
	}

	public function addQuestions(array $questions): Category
	{
		$this->questions += $questions;
		return $this;
	}


	public function setIsPublished(int $isPublished): Category
	{
		$this->isPublished = $isPublished;
		return $this;
	}


	public function setChild(array $child): Category
	{
		$this->child = $child;
		return $this;
	}


	public function setParent($parent): Category
	{
		$this->parent = $parent;
		return $this;
	}

	public function setClass($class)
	{
		$this->class= $class;
		return $this;
	}


}