<?php declare(strict_types = 1);

namespace Questions\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Gedmo\Mapping\Annotation as Gedmo;


/**
 * @ORM\Table(name="questions__answer")
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\SortableRepository")
 */
class Answer
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="answer", type="string", length=1000, nullable=false)
	 */
	public $answer;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", options={"default":1},nullable=false)
	 */
	public $isPublished;

	/**
	 * @var float
	 * @ORM\Column(name="score", type="float", options={"default":0}, nullable=false)
	 */
	public $score;

	/**
	 * @var string
	 * @ORM\Column(name="answer_class", type="string", nullable=true)
	 */
	public $answerClass;

	/**
	 * @var Question
	 * @ORM\ManyToOne(targetEntity="Question", inversedBy="answers")
	 * @ORM\JoinColumn(name="question_id", referencedColumnName="id")
	 */
	public $question;

	/**
	 * @var int
	 *
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	public $position;

	/**
	 * @var array
	 * @ORM\Column(name="params", type="array", nullable=true)
	 */
	public $params;

	public function __construct($answer, Question $question, $score = 0)
	{
		$this->answer = $answer;
		$this->score = $score;
		$this->question = $question;
		$this->isPublished = 1;
		$this->params = [];
	}

	public function setParam($key, $value)
	{
		if ($value == null) {
			unset($this->params[$key]);
		} else {
			$this->params[$key] = $value;
		}
	}

	public function getParam($key)
	{
		if (isset($this->params[$key]))
			return $this->params[$key];

		return null;
	}

	public function setPosition($position) {
		$this->position = intval($position);
	}
}