<?php declare(strict_types=1);

namespace Questions\AdminModule\Components\Answer;

use Core\Model\UI\Form\BaseForm;
use Core\Model\UI\BaseControl;
use Nette\Utils\ArrayHash;
use Nette\Utils\Json;
use Questions\AdminModule\Components\Answer\AnswerForm;
use Questions\Model\Answers;
use Questions\Model\Entities\Answer;
use Questions\Model\Entities\Question;
use Questions\Model\Questions;
use SimpleProducts\Model\Entities\Product;
use SimpleProducts\Model\SimpleProducts;

class EditAnswerForm extends AnswerForm
{
	/** @var Answer */
	protected $answer;

	/** @var SimpleProducts */
	protected $productsService;

	/** @var Answers */
	protected $answersService;

	public $onAdd = [];

	public function __construct(SimpleProducts $simpleProducts, Answers $answers)
	{
		$this->productsService = $simpleProducts;
		$this->answersService = $answers;
	}

	public function setAnswer($id)
	{
		$this->answer = $this->answersService->get($id);
		bdump($this->answer);
		if ($this->answer) {
			$a = $this->answer;
			$this['form']->setDefaults([
				'answer' => $a->answer,
				'isPublished' => $a->isPublished,
				'score' => $a->score,
				'answerClass' => $a->answerClass,
				'recommendation' => $a->getParam('recommendation'),
			]);
		}
	}

	public function getAnswer() {
		return $this->answer;
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addEditor('answer', 'questions.answerForm.answer')->setRequired();
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);
		$form->addEditor('recommendation', 'questions.answerForm.recommendation')->setHeight(100);
		$form->addText('score', 'questions.answerForm.score')->setType('number');
		$form->addText('answerClass','questions.answerForm.class');
		$form->addSubmit('submit','questions.answerForm.saveAnswer');
		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			$a = $this->answer;
			$a->answer = $values->answer;
			$a->score = $values->score;
			$a->answerClass = $values->answerClass;
			$a->isPublished = $values->isPublished;
			$a->setParam('recommendation', $values->recommendation);

			$this->em->persist($a)->flush();

		} catch (\Exception $e) {
			$form->addError($e->getMessage());
			return false;
		}
	}


}
