<?php declare(strict_types = 1);

namespace Questions\AdminModule\Components\Categories;


use Core\Model\UI\BaseControl;
use Nette\Utils\Html;
use Questions\Model\Categories;
use Questions\Model\Entities\Category;

class CategoriesGrid extends BaseControl
{
	/** @var Categories */
	protected $categoriesService;

	public function __construct(Categories $categories)
	{
		$this->categoriesService = $categories;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$qb = $this->categoriesService->getAll();
		$grid->setDataSource($qb);
		$grid->setSortable();
		$grid->setSortableHandler('categoriesGrid:gridSortableRow!');

		// Columns
		$grid->addColumnLink('title', 'default.title', 'Default:editCategory');
		$grid->addColumnText('parent', 'default.parent', 'parent.title');
		$grid->addColumnStatus('isPublished', 'default.isPublished')->setAlign('center')
			->addOption(1, 'default.publish')->setIcon('check')->setClass('btn-success')->setShowTitle(false)->endOption()
			->addOption(0, 'default.unPublish')->setIcon('times')->setClass('btn-danger')->setShowTitle(false)->endOption()
			->onChange[] = [$this, 'gridPublishChange'];

		// Filter

		// Actions
		$grid->addAction('edit', '', 'Default:editCategory')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setConfirm('default.reallyDelete')->setIcon('times')->setBsType('danger')->addClass('ajax');

		// Columns prototype
		$grid->getColumn('isPublished')->getElementPrototype('th')->class[] = 'w1';

		$grid->setRowCallback(function(Category $row, Html $tr) {
			$groupId = ($row->getParent() ? $row->getParent()->getId() : 0) . '-' .
				($row->getParent() ? $row->getParent()->getId() : '0') . '-' . $row->getLevel();

			$tr->addClass('group_' . $groupId);
			$tr->addAttributes(['data-group-tree' => $groupId]);

			return $tr;
		});

		return $grid;
	}

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->categoriesService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	public function handleGridSortableRow()
	{
		$presenter = $this->getPresenter();
		$request   = $presenter->getHttpRequest();
		$id        = $request->getPost('id', null);
		$position  = $request->getPost('position', null);

		bdump($position);

		if ($id != null && $position != null && $this->categoriesService->setPosition($id, $position)) {
			$presenter->flashMessageSuccess('default.positionChanged');
		} else {
			$presenter->flashMessageDanger('default.positionChangeFailed');
		}

		$presenter->redrawControl('flashes');
	}

	public function gridPublishChange($id, $newStatus)
	{
		$presenter = $this->getPresenter();

		if ($this->categoriesService->setPublish($id, $newStatus))
			$presenter->flashMessageSuccess('default.publishChanged');
		else
			$presenter->flashMessageDanger('default.publishChangeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->redrawItem($id);
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

}


