<?php declare(strict_types = 1);

namespace Questions\AdminModule\Components\Question;


use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use Questions\Model\Categories;
use Questions\Model\Entities\Category;
use Questions\Model\Entities\Question;
use Questions\Model\Questions;

class QuestionForm extends BaseControl
{
	/** @var Question */
	protected $question;

	/** @var Questions */
	protected $questionsService;

	/** @var Categories */
	protected $categoriesService;

	public function __construct(Questions $questionsService, Categories $categoriesService)
	{
		$this->questionsService = $questionsService;
		$this->categoriesService = $categoriesService;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();
		$categories = [];

		foreach ($this->categoriesService->getEr()->findBy([], ['title' => 'ASC']) as $g) {
			$arr = [];
			$t = $g;
			while ($t->parent) {
				$t = $t->parent;
				$arr[] = $t->title;
			}
			$categories[$g->getId()] = ($arr ? implode(' -> ', $arr) . ' -> ' : '') . $g->title;
		}
		asort($categories);

		$form->addTextArea('question', 'questions.default.question')->setRequired();
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);
		$form->addCheckbox('multipleAnswers','questions.questionForm.multipleAnswers')->setDefaultValue(0);
		$form->addText('questionClass', 'questions.questionForm.class');
		$form->addText('score', 'questions.questionForm.score')->setType('number');
		$form->addTextArea('hint','questions.questionForm.hint');
		$form->addSelect('category', 'default.category', $categories);
		$form->addSubmit('submit', 'default.save');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			if ($this->question) {
				$question = $this->question;
				$flashMessage = 'questions.categoriesForm.edited';
			} else {
				$question = new Question($values->question);
				$flashMessage = 'questions.categoriesForm.added';
			}

			$question->question = $values->question;
			$question->score = $values->score;
			$question->questionClass = $values->questionClass;
			$question->isPublished = $values->isPublished;
			$question->hint = $values->hint;
			$question->multipleAnswers = $values->multipleAnswers;

			$question->groups = [$this->categoriesService->get($values->category)];

			$this->em->persist($question)->flush();
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}

	}

	public function setQuestion($id)
	{
		$this->question = $this->questionsService->get($id);

		if ($this->question) {
			$this['form']->setDefaults([
				'question'       => $this->question->question,
				'isPublished' => $this->question->isPublished,
				'score' => $this->question->score,
				'questionClass' => $this->question->questionClass,
				'hint' => $this->question->hint,
				'multipleAnswers' => $this->question->multipleAnswers,
				'category' => $this->question->groups[0]->getId()
			]);

		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}


}
