<?php
/**
 * Created by PhpStorm.
 * User: Adam Ouhrabka
 * Date: 11.10.2018
 * Time: 14:15
 */

namespace Questions\FrontModule\Model;


use Core\Model\Helpers\BaseEntityService;
use Questions\Model\Entities\Category;
use Questions\FrontModule\Model\Dao as QuestionsDao;
use Questions\Model\Entities\Question;

class Categories extends BaseEntityService
{
	protected $entityClass = Category::class;

	public function getAllByRootGroups($publishedOnly = false)
	{
		$categoriesRaw = $this->getEr()->createQueryBuilder('c')
			->where('c.parent IS NULL')
			->orderBy('c.position', 'ASC')
			->getQuery()
			->getResult();

		$categories = [];
		foreach ($categoriesRaw as $c) {
			$category = (new QuestionsDao\Category())
				->setId($c->getId())
				->setTitle($c->title)
				->setClass($c->class);

			$questions = [];

			foreach ($c->children as $child) {
				$questions += $this->getQuestions($child, $publishedOnly);
			}

			$questions += $this->getQuestions($c, $publishedOnly);

			$category->setQuestions($questions);

			if ($category->id === 3) {
				$category->questions = $this->changeQuestionPosition($category->questions, 19, 11);
			}

			if ($category->id === 1) {
				$category->questions = $this->changeQuestionPosition($category->questions, 4, 2);
			}

			$categories[$category->id] = $category;
		}

		return $categories;
	}

	private function changeQuestionPosition($array, $fromIndex, $toIndex) {
		if (count($array) < $fromIndex) {
			return $array;
		}

		$result = [];
		$i = 0;
		$itemForMove = array_values($array)[$fromIndex];
		foreach ($array as $k => $v) {
			if ($i === $fromIndex) {
				$i++;
				continue;
			}

			if ($i === $toIndex) {
				$result[$itemForMove->id] = $itemForMove;
			}

			$result[$k] = $v;

			$i++;
		}

		return $result;
	}

	/**
	 * @param Category $c
	 * @param          $publishedOnly
	 *
	 * @return array
	 */
	private function getQuestions($c, $publishedOnly = false)
	{
		$questions = [];

		$arr = $c->questions->toArray();
		if ($c->getId() === 4) {
			usort($arr, function($a, $b) {
				return $a->position > $b->position;
			});
		}

		foreach ($arr as $q) {
			/** @var Question $q */

			if ($publishedOnly && $q->isPublished == 0) {
				continue;
			}

			$question = (new QuestionsDao\Question())
				->setId($q->getId())
				->setQuestion($q->question)
				->setIsPublished($q->isPublished)
				->setClass($q->questionClass)
				->setMultipleAnswers($q->multipleAnswers)
				->setGroups($q->groups)
				->setFirstParent($c)
				->setFirstParentId($c->getId());

			$answers = [];
			foreach ($q->answers as $a) {
				$answer           = (new QuestionsDao\Answer())
					->setIsPublished($a->isPublished)
					->setId($a->getId())
					->setAnswer($a->answer)
					->setScore($a->score)
					->setQuestion($a->question)
					->setParams($a->params)
					->setClass($a->answerClass);
				$answer->position = $a->position;

				$answers[$answer->id] = $answer;
			}

			$question->setAnswers($answers);
			$questions[$question->id] = $question;
		}

		return $questions;
	}

}
