<?php declare(strict_types = 1);

namespace Questions\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use Questions\Model\Entities\Category;


class Categories extends BaseEntityService
{
	protected $entityClass = Category::class;

	use TPublish;

	public function getAll()
	{
		return $this->getEr()->createQueryBuilder('c')
			->orderBy('c.position','ASC');
	}

	public function setPosition($id, $position)
	{
		/** @var Category $item */
		if ($item = $this->get($id)) {
			$item->position = $position;
			bdump($item);
			$this->em->persist($item);
			$this->em->flush();
			return true;
		}

		return false;
	}

}