<?php declare(strict_types = 1);

namespace Questions\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="questions__question")
 * @ORM\Entity
 */
class Question
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="question", type="string", length=1000, nullable=false)
	 */
	public $question;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", options={"default":1}, nullable=false)
	 */
	public $isPublished;

	/**
	 * @var float
	 * @ORM\Column(name="score", type="float", options={"default":0}, nullable=false)
	 */
	public $score;

	/**
	 * @var string
	 * @ORM\Column(name="hint", type="string",nullable=true)
	 */
	public $hint;

	/**
	 * @var string
	 * @ORM\Column(name="question_class", type="string", nullable=true)
	 */
	public $questionClass;

	/**
	 * @var bool
	 * @ORM\Column(name="multiple_answers", type="smallint", options={"default:0"}, nullable=false)
	 */
	public $multipleAnswers;

	/**
	 * @var int
	 *
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	public $position;

	/**
	 * @var Answer[]
	 * @ORM\OneToMany(targetEntity="Answer", mappedBy="question")
	 * @ORM\OrderBy({"position" = "ASC"})
	 */
	public $answers;

	/**
	 * @var array
	 * @ORM\Column(name="params", type="array", nullable=true)
	 */
	public $params;

	/**
	 * @var Category[]
	 *
	 * @ORM\ManyToMany(targetEntity="Category", inversedBy="questions")
	 * @ORM\JoinTable(name="questions__category_questions",
	 *  joinColumns={@ORM\JoinColumn(name="question_id", referencedColumnName="id")},
	 *  inverseJoinColumns={@ORM\JoinColumn(name="category_id", referencedColumnName="id")})
	 */
	public $groups;

	public function __construct($question)
	{
		$this->question = $question;
		$this->score = 0;
		$this->isPublished = 1;
		$this->multipleAnswers = 0;
		$this->answers = new ArrayCollection();
		$this->groups = new ArrayCollection();
		$this->params = [];
	}

	public function addAnswer(Answer $answer)
	{
		$this->answers->add($answer);
	}


}

