<?php
/**
 * Created by PhpStorm.
 * User: Adam Ouhrabka
 * Date: 11.10.2018
 * Time: 12:53
 */

namespace Questions\Model\Navigation;


use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class Questions extends BaseNavigation implements INavigationItem
{

	protected $title     = 'questions';
	protected $presenter = 'Questions:Front:Default';
	protected $action    = 'default';

	public function __construct()
	{

	}

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer()
	{
		$container = new BaseContainer();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{

	}

	public function presenterActionCheck($presenter, $action)
	{
		if ($this->presenter == $presenter && $this->action == $action)
			return 1;

		return false;
	}

	public function routerIn($componentParams, $urlParams = [])
	{
		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		return $navigation->isHomepage ? '' : '/' . $navigation->alias;
	}
}
