<?php declare(strict_types = 1);

namespace RealEstates\AdminModule\Components\Author;

use Core\Model\UI\BaseControl;
use Nette\Utils\Html;
use RealEstates\AdminModule\Model\Authors;

/**
 * Class AuthorsGrid
 * @package RealEstates\AdminModule\Components
 */
class AuthorsGrid extends BaseControl
{
	/** @var Authors */
	protected $authorsService;

	public function __construct(Authors $authors)
	{
		$this->authorsService = $authors;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$qb = $this->authorsService->getEr()->createQueryBuilder('a')->orderBy('a.name', 'ASC');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnText('name', 'default.name')->setRenderer(function($row) {
			return Html::el('a class=ajax', ['href' => $this->getPresenter()->link('authorForm!', [$row->getId()])])->setText($row->name);
		});

		// Filter
		$grid->addFilterText('name', '');

		// Actions
		$grid->addAction('delete', '', 'delete!')->setConfirm('default.reallyDelete')->setIcon('times')->setBsType('danger')->addClass('ajax');

		// Columns prototype

		return $grid;
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		$r         = $this->authorsService->remove($id);
		if (is_string($r)) {
			$presenter->flashMessageInfo($r);
		} else if ($r) {
			$presenter->flashMessageSuccess('default.removed');
		} else {
			$presenter->flashMessageDanger('default.removeFailed');
		}

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	/*******************************************************************************************************************
	 * =================  Grid function
	 */
}